/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.VariantInfo;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.synthesis.en.EnglishSynthesizer;

public abstract class AbstractEnglishSpellerRule
extends MorfologikSpellerRule {
    private final EnglishSynthesizer synthesizer = new EnglishSynthesizer();

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, Collections.emptyList());
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, userConfig, altLanguages, null);
    }

    protected static Map<String, String> loadWordlist(String path, int column) {
        if (column != 0 && column != 1) {
            throw new IllegalArgumentException("Only column 0 and 1 are supported: " + column);
        }
        HashMap<String, String> words = new HashMap<String, String>();
        try (InputStreamReader isr = new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(path), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Unexpected format in " + path + ": " + line + " - expected two parts delimited by ';'");
                }
                words.put(parts[column], parts[column == 1 ? 0 : 1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return words;
    }

    @Experimental
    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.ignoreWordsWithLength = 1;
        this.setCheckCompound(true);
        this.addExamplePair(Example.wrong("This <marker>sentenc</marker> contains a spelling mistake."), Example.fixed("This <marker>sentence</marker> contains a spelling mistake."));
        String languageSpecificIgnoreFile = this.getSpellingFileName().replace(".txt", "_" + language.getShortCodeWithCountryAndVariant() + ".txt");
        for (String ignoreWord : this.wordListLoader.loadWords(languageSpecificIgnoreFile)) {
            this.addIgnoreWords(ignoreWord);
        }
    }

    @Override
    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar) throws IOException {
        List<RuleMatch> ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar);
        if (ruleMatches.size() > 0) {
            IrregularForms forms = this.getIrregularFormsOrNull(word);
            if (forms != null) {
                String message = "Possible spelling mistake. Did you mean <suggestion>" + forms.forms.get(0) + "</suggestion>, the " + forms.formName + " form of the " + forms.posName + " '" + forms.baseform + "'?";
                this.addFormsToFirstMatch(message, sentence, ruleMatches, forms.forms);
            } else {
                VariantInfo variantInfo = this.isValidInOtherVariant(word);
                if (variantInfo != null) {
                    String message = "Possible spelling mistake. '" + word + "' is " + variantInfo.getVariantName() + ".";
                    this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, variantInfo.otherVariant());
                }
            }
        }
        return ruleMatches;
    }

    @Nullable
    protected VariantInfo isValidInOtherVariant(String word) {
        return null;
    }

    private void addFormsToFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, List<String> forms) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch(this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        ArrayList<String> allSuggestions = new ArrayList<String>(forms);
        for (String repl : oldMatch.getSuggestedReplacements()) {
            if (allSuggestions.contains(repl)) continue;
            allSuggestions.add(repl);
        }
        newMatch.setSuggestedReplacements(allSuggestions);
        ruleMatches.set(0, newMatch);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch(this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word) {
        IrregularForms irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("ed"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("d"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "s", Arrays.asList("s"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "es", Arrays.asList("es"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "er", Arrays.asList("er"), "JJR", "adjective", "comparative");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "est", Arrays.asList("est"), "JJS", "adjective", "superlative");
        return irregularFormsOrNull;
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word, String wordSuffix, List<String> suffixes, String posTag, String posName, String formName) {
        try {
            for (String suffix : suffixes) {
                if (!word.endsWith(wordSuffix)) continue;
                String baseForm = word.substring(0, word.length() - suffix.length());
                String[] forms = this.synthesizer.synthesize(new AnalyzedToken(word, null, baseForm), posTag);
                ArrayList<String> result = new ArrayList<String>();
                for (String form : forms) {
                    if (this.speller1.isMisspelled(form)) continue;
                    result.add(form);
                }
                result.remove(word);
                result.remove("badder");
                result.remove("baddest");
                result.remove("spake");
                if (result.size() <= 0) continue;
                return new IrregularForms(baseForm, posName, formName, result);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        if ("Alot".equals(word)) {
            return Arrays.asList("A lot");
        }
        if ("alot".equals(word)) {
            return Arrays.asList("a lot");
        }
        if ("thru".equals(word)) {
            return Arrays.asList("through");
        }
        if ("speach".equals(word)) {
            return Arrays.asList("speech");
        }
        if ("icecreem".equals(word)) {
            return Arrays.asList("ice cream");
        }
        if ("fora".equals(word)) {
            return Arrays.asList("for a");
        }
        if ("te".equals(word)) {
            return Arrays.asList("the");
        }
        if ("todays".equals(word)) {
            return Arrays.asList("today's");
        }
        if ("heres".equals(word)) {
            return Arrays.asList("here's");
        }
        if ("Heres".equals(word)) {
            return Arrays.asList("Here's");
        }
        if ("McDonalds".equals(word)) {
            return Arrays.asList("McDonald's");
        }
        if ("ecommerce".equals(word)) {
            return Arrays.asList("e-commerce");
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }

    private static class IrregularForms {
        final String baseform;
        final String posName;
        final String formName;
        final List<String> forms;

        private IrregularForms(String baseform, String posName, String formName, List<String> forms) {
            this.baseform = baseform;
            this.posName = posName;
            this.formName = formName;
            this.forms = forms;
        }
    }
}

